/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.util.Dictionary;
import java.util.Map;
import org.apache.sling.testing.mock.osgi.MapUtil;
import org.apache.sling.testing.mock.osgi.MockBundleContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentInstance;

class MockComponentContext
implements ComponentContext {
    private final MockBundleContext bundleContext;
    private final Dictionary<String, Object> properties;
    private final Map<String, Object> propertiesAsMap;
    private final Bundle usingBundle;

    public MockComponentContext(MockBundleContext mockBundleContext, Dictionary<String, Object> properties, Bundle usingBundle) {
        this.bundleContext = mockBundleContext;
        this.properties = properties;
        this.propertiesAsMap = MapUtil.toMap(properties);
        this.usingBundle = usingBundle;
    }

    public MockComponentContext(MockBundleContext mockBundleContext, Map<String, Object> propertiesAsMap, Bundle usingBundle) {
        this.bundleContext = mockBundleContext;
        this.properties = MapUtil.toDictionary(propertiesAsMap);
        this.propertiesAsMap = propertiesAsMap;
        this.usingBundle = usingBundle;
    }

    public Dictionary<String, Object> getProperties() {
        return this.properties;
    }

    public Map<String, Object> getPropertiesAsMap() {
        return this.propertiesAsMap;
    }

    public <S> S locateService(String name, ServiceReference<S> reference) {
        return this.bundleContext.locateService(name, reference);
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void disableComponent(String name) {
    }

    public void enableComponent(String name) {
    }

    public Bundle getUsingBundle() {
        return this.usingBundle;
    }

    public <S> ComponentInstance<S> getComponentInstance() {
        throw new UnsupportedOperationException();
    }

    public ServiceReference<?> getServiceReference() {
        throw new UnsupportedOperationException();
    }

    public <S> S locateService(String name) {
        throw new UnsupportedOperationException();
    }

    public Object[] locateServices(String name) {
        throw new UnsupportedOperationException();
    }
}

