/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.util.Arrays;
import java.util.Objects;

public class ComparablePredicate
implements Comparable<ComparablePredicate> {
    public final String name;
    public final int[] outcomes;
    public final double[] params;

    public ComparablePredicate(String n, int[] ocs, double[] ps) {
        this.name = n;
        this.outcomes = ocs;
        this.params = ps;
    }

    @Override
    public int compareTo(ComparablePredicate cp) {
        int smallerLength = StrictMath.min(this.outcomes.length, cp.outcomes.length);
        for (int i = 0; i < smallerLength; ++i) {
            int compareOutcomes = Integer.compare(this.outcomes[i], cp.outcomes[i]);
            if (compareOutcomes == 0) continue;
            return compareOutcomes;
        }
        return Integer.compare(this.outcomes.length, cp.outcomes.length);
    }

    public int hashCode() {
        return Objects.hash(this.name, Arrays.hashCode(this.outcomes), Arrays.hashCode(this.params));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ComparablePredicate) {
            ComparablePredicate other = (ComparablePredicate)obj;
            return Objects.equals(this.name, other.name) && Arrays.equals(this.outcomes, other.outcomes) && Arrays.equals(this.params, other.params);
        }
        return false;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (int outcome : this.outcomes) {
            s.append(" ").append(outcome);
        }
        return s.toString();
    }
}

