/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.util;

import jakarta.faces.application.FacesMessage;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import java.util.List;
import java.util.Map;

public final class DebugUtils {
    private DebugUtils() {
    }

    public static String toString(UIComponent component, int offset) {
        return DebugUtils.toString(component, offset, false, null);
    }

    public static String toString(UIComponent component, int offset, boolean asFacet, Integer childIndex) {
        StringBuilder result = new StringBuilder();
        if (component == null) {
            result.append("null");
        } else {
            Map facets;
            if (!asFacet) {
                result.append(DebugUtils.spaces(offset));
                if (childIndex != null) {
                    result.append('[');
                    result.append(childIndex);
                    result.append("] ");
                }
                result.append(DebugUtils.toString(component));
            }
            if ((facets = component.getFacets()).size() > 0) {
                for (Map.Entry entry : facets.entrySet()) {
                    UIComponent facet = (UIComponent)entry.getValue();
                    result.append(DebugUtils.spaces(offset + 1));
                    result.append('[');
                    result.append((String)entry.getKey());
                    result.append("] ");
                    result.append(DebugUtils.toString(facet));
                    result.append(DebugUtils.toString(facet, offset + 1, true, null));
                }
            }
            List children = component.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                result.append(DebugUtils.toString((UIComponent)children.get(i), offset + 1, false, i));
            }
        }
        return result.toString();
    }

    public static String toString(UIComponent component) {
        StringBuilder buf = new StringBuilder(component.getClass().getName());
        buf.append(" ");
        buf.append(component.getRendererType());
        buf.append(" ");
        buf.append(component.getClientId(FacesContext.getCurrentInstance()));
        if (component instanceof UIViewRoot) {
            buf.append(" viewId=");
            buf.append(((UIViewRoot)component).getViewId());
        }
        buf.append(" rendered=");
        buf.append(component.isRendered());
        buf.append('\n');
        return buf.toString();
    }

    public static String spaces(int n) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            buffer.append("  ");
        }
        return buffer.toString();
    }

    public static void addDevelopmentMessage(FacesContext facesContext, String message) {
        if (facesContext.isProjectStage(ProjectStage.Development)) {
            facesContext.addMessage(null, new FacesMessage(message));
        }
    }
}

