/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.context.FacesContext;
import jakarta.faces.model.SelectItem;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.tobago.internal.component.AbstractUIInput;
import org.apache.myfaces.tobago.internal.component.AbstractUISuggest;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.SelectItemUtils;
import org.apache.myfaces.tobago.model.AutoSuggestItem;
import org.apache.myfaces.tobago.model.AutoSuggestItems;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.html.CustomAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuggestRenderer<T extends AbstractUISuggest>
extends RendererBase<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public void decodeInternal(FacesContext facesContext, T component) {
        String clientId = component.getClientId(facesContext);
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        if (requestParameterMap.containsKey(clientId)) {
            AbstractUIInput input;
            String query = (String)requestParameterMap.get(clientId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("suggest query='{}'", (Object)query);
            }
            if ((input = ComponentUtils.findAncestor(component, AbstractUIInput.class)) != null) {
                input.setSubmittedValue(query);
            }
            ((AbstractUISuggest)((Object)component)).setQuery(query);
        }
    }

    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        AbstractUIInput input = ComponentUtils.findAncestor(component, AbstractUIInput.class);
        int totalCount = ((AbstractUISuggest)((Object)component)).getTotalCount();
        List<SelectItem> items = SelectItemUtils.getItemList(facesContext, component);
        if (totalCount == -1 || items.size() < totalCount) {
            totalCount = items.size();
        }
        String[] array = new String[totalCount];
        for (int i = 0; i < totalCount; ++i) {
            array[i] = items.get(i).getLabel();
        }
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.TOBAGO_SUGGEST);
        String clientId = component.getClientId(facesContext);
        writer.writeIdAttribute(clientId);
        if (input != null) {
            writer.writeAttribute(HtmlAttributes.FOR, input.getFieldId(facesContext), false);
        } else {
            LOG.error("No ancestor with type AbstractUIInput found for suggest id={}", (Object)clientId);
        }
        writer.writeAttribute((MarkupLanguageAttributes)CustomAttributes.MIN_CHARS, ((AbstractUISuggest)((Object)component)).getMinimumCharacters());
        writer.writeAttribute((MarkupLanguageAttributes)CustomAttributes.DELAY, ((AbstractUISuggest)((Object)component)).getDelay());
        writer.writeAttribute((MarkupLanguageAttributes)CustomAttributes.MAX_ITEMS, ((AbstractUISuggest)((Object)component)).getMaximumItems());
        writer.writeAttribute((MarkupLanguageAttributes)CustomAttributes.UPDATE, ((AbstractUISuggest)((Object)component)).isUpdate());
        writer.writeAttribute((MarkupLanguageAttributes)CustomAttributes.TOTAL_COUNT, totalCount);
        writer.writeAttribute((MarkupLanguageAttributes)CustomAttributes.LOCAL_MENU, ((AbstractUISuggest)((Object)component)).isLocalMenu());
        writer.writeAttribute(CustomAttributes.FILTER, ((AbstractUISuggest)((Object)component)).getFilter().getValue(), false);
        writer.writeAttribute(CustomAttributes.ITEMS, JsonUtils.encode(array), true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("suggest list: {}", (Object)JsonUtils.encode(array));
        }
        writer.startElement(HtmlElements.INPUT);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        writer.writeAttribute(HtmlAttributes.NAME, clientId, false);
        writer.endElement(HtmlElements.INPUT);
        writer.endElement(HtmlElements.TOBAGO_SUGGEST);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AutoSuggestItems createAutoSuggestItems(Object object) {
        if (object instanceof AutoSuggestItems) {
            return (AutoSuggestItems)object;
        }
        AutoSuggestItems autoSuggestItems = new AutoSuggestItems();
        if (object instanceof List && !((List)object).isEmpty()) {
            if (((List)object).get(0) instanceof AutoSuggestItem) {
                autoSuggestItems.setItems((List)object);
                return autoSuggestItems;
            } else {
                if (!(((List)object).get(0) instanceof String)) throw new ClassCastException("Can't create AutoSuggestItems from '" + String.valueOf(object) + "'. Elements needs to be " + String.class.getName() + " or " + AutoSuggestItem.class.getName());
                ArrayList<AutoSuggestItem> items = new ArrayList<AutoSuggestItem>(((List)object).size());
                for (int i = 0; i < ((List)object).size(); ++i) {
                    AutoSuggestItem item = new AutoSuggestItem();
                    item.setLabel((String)((List)object).get(i));
                    item.setValue((String)((List)object).get(i));
                    items.add(item);
                }
                autoSuggestItems.setItems(items);
            }
            return autoSuggestItems;
        } else {
            autoSuggestItems.setItems(Collections.emptyList());
        }
        return autoSuggestItems;
    }
}

