/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component.behavior;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.behavior.BehaviorBase;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorContext;
import jakarta.faces.component.behavior.ClientBehaviorHint;
import jakarta.faces.context.FacesContext;
import jakarta.faces.render.ClientBehaviorRenderer;
import java.util.Collections;
import java.util.Set;
import org.apache.myfaces.core.api.shared.lang.Assert;

public class ClientBehaviorBase
extends BehaviorBase
implements ClientBehavior {
    private transient FacesContext _facesContext;

    @Override
    public void decode(FacesContext context, UIComponent component) {
        Assert.notNull(context, "context");
        Assert.notNull(component, "component");
        ClientBehaviorRenderer renderer = this.getRenderer(context);
        if (renderer != null) {
            renderer.decode(context, component, this);
        }
    }

    @Override
    public Set<ClientBehaviorHint> getHints() {
        return Collections.emptySet();
    }

    public String getRendererType() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getScript(ClientBehaviorContext behaviorContext) {
        Assert.notNull(behaviorContext, "behaviorContext");
        ClientBehaviorRenderer renderer = this.getRenderer(behaviorContext.getFacesContext());
        if (renderer != null) {
            try {
                this.setCachedFacesContext(behaviorContext.getFacesContext());
                String string = renderer.getScript(behaviorContext, this);
                return string;
            }
            finally {
                this.setCachedFacesContext(null);
            }
        }
        return null;
    }

    protected ClientBehaviorRenderer getRenderer(FacesContext context) {
        Assert.notNull(context, "context");
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            return context.getRenderKit().getClientBehaviorRenderer(rendererType);
        }
        return null;
    }

    FacesContext getFacesContext() {
        if (this._facesContext == null) {
            return FacesContext.getCurrentInstance();
        }
        return this._facesContext;
    }

    boolean isCachedFacesContext() {
        return this._facesContext != null;
    }

    void setCachedFacesContext(FacesContext facesContext) {
        this._facesContext = facesContext;
    }
}

