/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.appserver.tomcat;

import aQute.bnd.annotation.spi.ServiceProvider;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.juli.logging.Log;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.LoggerContext;

@ServiceProvider(value=Log.class, resolution="optional")
public class TomcatLogger
implements Log {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = TomcatLogger.class.getName();
    private static final String[] FILE_NAMES = new String[]{"log4j2-tomcat.xml", "log4j2-tomcat.json", "log4j2-tomcat.yaml", "log4j2-tomcat.yml", "log4j2-tomcat.properties"};
    private final ExtendedLogger logger;

    public TomcatLogger() {
        this.logger = null;
    }

    public TomcatLogger(String name) {
        this.logger = PrivateManager.getLogger(name);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.logger.isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void trace(Object o) {
        this.logger.logIfEnabled(FQCN, Level.TRACE, null, o, null);
    }

    public void trace(Object o, Throwable throwable) {
        this.logger.logIfEnabled(FQCN, Level.TRACE, null, o, throwable);
    }

    public void debug(Object o) {
        this.logger.logIfEnabled(FQCN, Level.DEBUG, null, o, null);
    }

    public void debug(Object o, Throwable throwable) {
        this.logger.logIfEnabled(FQCN, Level.DEBUG, null, o, throwable);
    }

    public void info(Object o) {
        this.logger.logIfEnabled(FQCN, Level.INFO, null, o, null);
    }

    public void info(Object o, Throwable throwable) {
        this.logger.logIfEnabled(FQCN, Level.INFO, null, o, throwable);
    }

    public void warn(Object o) {
        this.logger.logIfEnabled(FQCN, Level.WARN, null, o, null);
    }

    public void warn(Object o, Throwable throwable) {
        this.logger.logIfEnabled(FQCN, Level.WARN, null, o, throwable);
    }

    public void error(Object o) {
        this.logger.logIfEnabled(FQCN, Level.ERROR, null, o, null);
    }

    public void error(Object o, Throwable throwable) {
        this.logger.logIfEnabled(FQCN, Level.ERROR, null, o, throwable);
    }

    public void fatal(Object o) {
        this.logger.logIfEnabled(FQCN, Level.FATAL, null, o, null);
    }

    public void fatal(Object o, Throwable throwable) {
        this.logger.logIfEnabled(FQCN, Level.FATAL, null, o, throwable);
    }

    private static class PrivateManager
    extends LogManager {
        private PrivateManager() {
        }

        @SuppressFBWarnings(value={"HSM_HIDING_METHOD"})
        public static LoggerContext getContext() {
            ClassLoader cl = TomcatLogger.class.getClassLoader();
            URI uri = null;
            for (String fileName : FILE_NAMES) {
                try {
                    URL url = cl.getResource(fileName);
                    if (url == null) continue;
                    uri = url.toURI();
                    break;
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            if (uri == null) {
                return PrivateManager.getContext((String)FQCN, (ClassLoader)cl, (boolean)false);
            }
            return PrivateManager.getContext((String)FQCN, (ClassLoader)cl, (boolean)false, uri, (String)"Tomcat");
        }

        public static ExtendedLogger getLogger(String name) {
            return PrivateManager.getContext().getLogger(name);
        }
    }
}

