/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.apache.commons.configuration2.tree.DefaultExpressionEngine;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.InMemoryNodeModel;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.NodeKeyResolver;
import org.apache.commons.configuration2.tree.NodeSelector;
import org.apache.commons.configuration2.tree.NodeStructureHelper;
import org.apache.commons.configuration2.tree.NodeUpdateData;
import org.apache.commons.configuration2.tree.QueryResult;
import org.apache.commons.configuration2.tree.TrackedNodeHandler;
import org.apache.commons.configuration2.tree.TreeData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestInMemoryNodeModelTrackedNodes {
    private static final String NEW_FIELD = "newTableField";
    private static final String TEST_KEY = "someTestKey";
    private static final String SELECTOR_KEY = "tables.table(1)";
    private static ImmutableNode root;
    private static NodeSelector selector;
    private InMemoryNodeModel model;

    private static void checkedForChangedField(ImmutableNode nodeFields, int idx) {
        Assertions.assertEquals((int)NodeStructureHelper.fieldsLength(1), (int)nodeFields.getChildren().size());
        int childIndex = 0;
        for (ImmutableNode field : nodeFields) {
            String expName = childIndex == idx ? NEW_FIELD : NodeStructureHelper.field(1, childIndex);
            TestInMemoryNodeModelTrackedNodes.checkFieldNode(field, expName);
            ++childIndex;
        }
    }

    private static void checkFieldNode(ImmutableNode nodeField, String name) {
        Assertions.assertEquals((Object)"field", (Object)nodeField.getNodeName());
        Assertions.assertEquals((int)1, (int)nodeField.getChildren().size());
        ImmutableNode nodeName = (ImmutableNode)nodeField.getChildren().get(0);
        Assertions.assertEquals((Object)"name", (Object)nodeName.getNodeName());
        Assertions.assertEquals((Object)name, (Object)nodeName.getValue());
    }

    private static void checkForAddedField(ImmutableNode nodeFields) {
        Assertions.assertEquals((int)(NodeStructureHelper.fieldsLength(1) + 1), (int)nodeFields.getChildren().size());
        ImmutableNode nodeField = (ImmutableNode)nodeFields.getChildren().get(NodeStructureHelper.fieldsLength(1));
        TestInMemoryNodeModelTrackedNodes.checkFieldNode(nodeField, NEW_FIELD);
    }

    private static void checkForRemovedField(ImmutableNode nodeFields, int idx) {
        Assertions.assertEquals((int)(NodeStructureHelper.fieldsLength(1) - 1), (int)nodeFields.getChildren().size());
        HashSet<String> expectedNames = new HashSet<String>();
        HashSet<String> actualNames = new HashSet<String>();
        for (int i = 0; i < NodeStructureHelper.fieldsLength(1); ++i) {
            if (idx == i) continue;
            expectedNames.add(NodeStructureHelper.field(1, i));
        }
        for (ImmutableNode field : nodeFields) {
            ImmutableNode nodeName = (ImmutableNode)field.getChildren().get(0);
            actualNames.add(String.valueOf(nodeName.getValue()));
        }
        Assertions.assertEquals(expectedNames, actualNames);
    }

    private static NodeKeyResolver<ImmutableNode> createResolver() {
        NodeKeyResolver<ImmutableNode> resolver = NodeStructureHelper.createResolverMock();
        NodeStructureHelper.prepareResolveKeyForQueries(resolver);
        return resolver;
    }

    private static void prepareResolverForUpdateKeys(NodeKeyResolver<ImmutableNode> resolver) {
        Mockito.when((Object)resolver.resolveUpdateKey((Object)((ImmutableNode)ArgumentMatchers.any()), (String)ArgumentMatchers.any(), ArgumentMatchers.any(), (NodeHandler)ArgumentMatchers.any())).thenAnswer(invocation -> {
            ImmutableNode root = (ImmutableNode)invocation.getArgument(0, ImmutableNode.class);
            String key = (String)invocation.getArgument(1, String.class);
            TreeData handler = (TreeData)invocation.getArgument(3, TreeData.class);
            List results = DefaultExpressionEngine.INSTANCE.query((Object)root, key, (NodeHandler)handler);
            Assertions.assertEquals((int)1, (int)results.size());
            return new NodeUpdateData(Collections.singletonMap((QueryResult)results.get(0), invocation.getArgument(2)), null, null, null);
        });
    }

    @BeforeAll
    public static void setUpBeforeClass() throws Exception {
        root = new ImmutableNode.Builder(1).addChild(NodeStructureHelper.ROOT_TABLES_TREE).create();
        selector = new NodeSelector(SELECTOR_KEY);
    }

    private void checkReplaceTrackedNode() {
        ImmutableNode newNode = new ImmutableNode.Builder().name("newNode").create();
        this.model.replaceTrackedNode(selector, newNode);
        Assertions.assertSame((Object)newNode, (Object)this.model.getTrackedNode(selector));
        Assertions.assertTrue((boolean)this.model.isTrackedNodeDetached(selector));
    }

    private void checkTrackChildNodesNoResult(List<ImmutableNode> queryResult) {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        Mockito.when((Object)resolver.resolveNodeKey((Object)root, TEST_KEY, this.model.getNodeHandler())).thenReturn(queryResult);
        TreeData oldData = this.model.getTreeData();
        Assertions.assertTrue((boolean)this.model.trackChildNodes(TEST_KEY, resolver).isEmpty());
        Assertions.assertSame((Object)oldData, (Object)this.model.getTreeData());
    }

    private void checkTrackChildNodeWithCreationInvalidKey(List<ImmutableNode> queryResult) {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        Mockito.when((Object)resolver.resolveNodeKey((Object)this.model.getRootNode(), TEST_KEY, this.model.getNodeHandler())).thenReturn(queryResult);
        Assertions.assertThrows(ConfigurationRuntimeException.class, () -> this.model.trackChildNodeWithCreation(TEST_KEY, "someChild", resolver));
    }

    private ImmutableNode fieldsNodeFromModel() {
        return NodeStructureHelper.nodeForKey(this.model, "tables/table(1)/fields");
    }

    private ImmutableNode fieldsNodeFromTrackedNode() {
        return NodeStructureHelper.nodeForKey(this.model.getTrackedNode(selector), "fields");
    }

    private void initDetachedNode(NodeKeyResolver<ImmutableNode> resolver) {
        this.model.trackNode(selector, resolver);
        this.model.clearTree("tables.table(0)", resolver);
    }

    private void prepareNodeKey(NodeKeyResolver<ImmutableNode> resolver, ImmutableNode node, String key) {
        HashMap cache = new HashMap();
        Mockito.when((Object)resolver.nodeKey((Object)node, cache, this.model.getNodeHandler())).thenReturn((Object)key);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.model = new InMemoryNodeModel(root);
    }

    @Test
    void testAddNodesOnDetachedNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        NodeStructureHelper.prepareResolveAddKeys(resolver);
        this.model.trackNode(selector, resolver);
        this.initDetachedNode(resolver);
        ImmutableNode rootNode = this.model.getRootNode();
        this.model.addNodes("fields", selector, Collections.singleton(NodeStructureHelper.createFieldNode(NEW_FIELD)), resolver);
        Assertions.assertSame((Object)rootNode, (Object)this.model.getRootNode());
        TestInMemoryNodeModelTrackedNodes.checkForAddedField(this.fieldsNodeFromTrackedNode());
    }

    @Test
    void testAddNodesOnTrackedNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        NodeStructureHelper.prepareResolveAddKeys(resolver);
        this.model.trackNode(selector, resolver);
        this.model.addNodes("fields", selector, Collections.singleton(NodeStructureHelper.createFieldNode(NEW_FIELD)), resolver);
        TestInMemoryNodeModelTrackedNodes.checkForAddedField(this.fieldsNodeFromModel());
        TestInMemoryNodeModelTrackedNodes.checkForAddedField(this.fieldsNodeFromTrackedNode());
    }

    @Test
    void testAddPropertyOnDetachedNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        NodeStructureHelper.prepareResolveAddKeys(resolver);
        this.model.trackNode(selector, resolver);
        this.initDetachedNode(resolver);
        ImmutableNode rootNode = this.model.getRootNode();
        this.model.addProperty("fields.field(-1).name", selector, Collections.singleton(NEW_FIELD), resolver);
        Assertions.assertSame((Object)rootNode, (Object)this.model.getRootNode());
        TestInMemoryNodeModelTrackedNodes.checkForAddedField(this.fieldsNodeFromTrackedNode());
    }

    @Test
    void testAddPropertyOnTrackedNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        NodeStructureHelper.prepareResolveAddKeys(resolver);
        this.model.trackNode(selector, resolver);
        this.model.addProperty("fields.field(-1).name", selector, Collections.singleton(NEW_FIELD), resolver);
        TestInMemoryNodeModelTrackedNodes.checkForAddedField(this.fieldsNodeFromModel());
        TestInMemoryNodeModelTrackedNodes.checkForAddedField(this.fieldsNodeFromTrackedNode());
    }

    @Test
    void testClearPropertyOnDetachedNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.initDetachedNode(resolver);
        ImmutableNode rootNode = this.model.getRootNode();
        this.model.clearProperty("fields.field(0).name", selector, resolver);
        Assertions.assertSame((Object)rootNode, (Object)this.model.getRootNode());
        ImmutableNode nodeFields = this.fieldsNodeFromTrackedNode();
        TestInMemoryNodeModelTrackedNodes.checkForRemovedField(nodeFields, 0);
    }

    @Test
    void testClearPropertyOnTrackedNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        this.model.clearProperty("fields.field(0).name", selector, resolver);
        ImmutableNode nodeFields = this.fieldsNodeFromModel();
        TestInMemoryNodeModelTrackedNodes.checkForRemovedField(nodeFields, 0);
    }

    @Test
    void testClearTreeOnDetachedNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.initDetachedNode(resolver);
        ImmutableNode rootNode = this.model.getRootNode();
        this.model.clearTree("fields.field(1)", selector, resolver);
        Assertions.assertSame((Object)rootNode, (Object)this.model.getRootNode());
        ImmutableNode nodeFields = this.fieldsNodeFromTrackedNode();
        TestInMemoryNodeModelTrackedNodes.checkForRemovedField(nodeFields, 1);
    }

    @Test
    void testClearTreeOnTrackedNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        this.model.clearTree("fields.field(1)", selector, resolver);
        ImmutableNode nodeFields = this.fieldsNodeFromModel();
        TestInMemoryNodeModelTrackedNodes.checkForRemovedField(nodeFields, 1);
    }

    @Test
    void testGetTrackedNodeAfterClear() {
        ImmutableNode node = NodeStructureHelper.nodeForKey(this.model, "tables/table(1)");
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        this.model.clear(resolver);
        Assertions.assertSame((Object)node, (Object)this.model.getTrackedNode(selector));
    }

    @Test
    void testGetTrackedNodeAfterSetRootNode() {
        ImmutableNode node = NodeStructureHelper.nodeForKey(this.model, "tables/table(1)");
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        this.model.setRootNode(root);
        Assertions.assertSame((Object)node, (Object)this.model.getTrackedNode(selector));
    }

    @Test
    void testGetTrackedNodeAfterUpdate() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        this.model.clearProperty("tables.table(1).fields.field(1).name", resolver);
        ImmutableNode node = this.model.getTrackedNode(selector);
        Assertions.assertEquals((Object)NodeStructureHelper.table(1), (Object)((ImmutableNode)node.getChildren().get(0)).getValue());
    }

    @Test
    void testGetTrackedNodeAfterUpdateNoLongerExisting() {
        ImmutableNode node = NodeStructureHelper.nodeForKey(this.model, "tables/table(1)");
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.initDetachedNode(resolver);
        Assertions.assertSame((Object)node, (Object)this.model.getTrackedNode(selector));
    }

    @Test
    void testGetTrackedNodeExisting() {
        ImmutableNode node = NodeStructureHelper.nodeForKey(this.model, "tables/table(1)");
        this.model.trackNode(selector, TestInMemoryNodeModelTrackedNodes.createResolver());
        Assertions.assertSame((Object)node, (Object)this.model.getTrackedNode(selector));
    }

    @Test
    void testGetTrackedNodeHandlerActive() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        NodeHandler handler = this.model.getTrackedNodeHandler(selector);
        TrackedNodeHandler tnh = (TrackedNodeHandler)Assertions.assertInstanceOf(TrackedNodeHandler.class, (Object)handler);
        Assertions.assertSame((Object)this.model.getTrackedNode(selector), (Object)handler.getRootNode());
        Assertions.assertSame((Object)this.model.getTreeData(), (Object)tnh.getParentHandler());
    }

    @Test
    void testGetTrackedNodeHandlerDetached() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        this.initDetachedNode(resolver);
        NodeHandler handler = this.model.getTrackedNodeHandler(selector);
        Assertions.assertSame((Object)this.model.getTrackedNode(selector), (Object)handler.getRootNode());
        Assertions.assertInstanceOf(TreeData.class, (Object)handler);
        Assertions.assertNotSame((Object)this.model.getNodeHandler(), (Object)handler);
    }

    @Test
    void testGetTrackedNodeNonExisting() {
        Assertions.assertThrows(ConfigurationRuntimeException.class, () -> this.model.getTrackedNode(selector));
    }

    @Test
    void testIsDetachedAfterClear() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        this.model.clear(resolver);
        Assertions.assertTrue((boolean)this.model.isTrackedNodeDetached(selector));
    }

    @Test
    void testIsDetachedAfterSetRoot() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        this.model.clearProperty("tables.table(1).fields.field(1).name", resolver);
        this.model.setRootNode(root);
        Assertions.assertTrue((boolean)this.model.isTrackedNodeDetached(selector));
    }

    @Test
    void testIsDetachedFalseAfterUpdate() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        this.model.clearProperty("tables.table(1).fields.field(1).name", resolver);
        Assertions.assertFalse((boolean)this.model.isTrackedNodeDetached(selector));
    }

    @Test
    void testIsDetachedFalseNoUpdates() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        Assertions.assertFalse((boolean)this.model.isTrackedNodeDetached(selector));
    }

    @Test
    void testIsDetachedTrue() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.initDetachedNode(resolver);
        Assertions.assertTrue((boolean)this.model.isTrackedNodeDetached(selector));
    }

    @Test
    void testReplaceTrackedNodeForActiveTrackedNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        this.checkReplaceTrackedNode();
    }

    @Test
    void testReplaceTrackedNodeForDetachedNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        this.initDetachedNode(resolver);
        this.checkReplaceTrackedNode();
    }

    @Test
    void testReplaceTrackedNodeNull() {
        this.model.trackNode(selector, TestInMemoryNodeModelTrackedNodes.createResolver());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.model.replaceTrackedNode(selector, null));
    }

    @Test
    void testSelectAndTrackNodes() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        String nodeKey1 = "tables/table(0)";
        String nodeKey2 = "tables/table(1)";
        ImmutableNode node1 = NodeStructureHelper.nodeForKey(root, "tables/table(0)");
        ImmutableNode node2 = NodeStructureHelper.nodeForKey(root, "tables/table(1)");
        Mockito.when((Object)resolver.resolveNodeKey((Object)root, TEST_KEY, this.model.getNodeHandler())).thenReturn(Arrays.asList(node1, node2));
        this.prepareNodeKey(resolver, node1, "tables/table(0)");
        this.prepareNodeKey(resolver, node2, "tables/table(1)");
        Collection selectors = this.model.selectAndTrackNodes(TEST_KEY, resolver);
        Iterator it = selectors.iterator();
        NodeSelector sel = (NodeSelector)it.next();
        Assertions.assertEquals((Object)new NodeSelector("tables/table(0)"), (Object)sel);
        Assertions.assertSame((Object)node1, (Object)this.model.getTrackedNode(sel));
        sel = (NodeSelector)it.next();
        Assertions.assertEquals((Object)new NodeSelector("tables/table(1)"), (Object)sel);
        Assertions.assertSame((Object)node2, (Object)this.model.getTrackedNode(sel));
        Assertions.assertFalse((boolean)it.hasNext());
    }

    @Test
    void testSelectAndTrackNodesNodeAlreadyTracked() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        ImmutableNode node = this.model.getTrackedNode(selector);
        Mockito.when((Object)resolver.resolveNodeKey((Object)root, TEST_KEY, this.model.getNodeHandler())).thenReturn(Collections.singletonList(node));
        this.prepareNodeKey(resolver, node, SELECTOR_KEY);
        Collection selectors = this.model.selectAndTrackNodes(TEST_KEY, resolver);
        Assertions.assertEquals((int)1, (int)selectors.size());
        Assertions.assertEquals((Object)selector, selectors.iterator().next());
        this.model.untrackNode(selector);
        Assertions.assertSame((Object)node, (Object)this.model.getTrackedNode(selector));
    }

    @Test
    void testSelectAndTrackNodesNoSelection() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        Mockito.when((Object)resolver.resolveNodeKey((Object)root, TEST_KEY, this.model.getNodeHandler())).thenReturn(Collections.emptyList());
        Assertions.assertTrue((boolean)this.model.selectAndTrackNodes(TEST_KEY, resolver).isEmpty());
    }

    @Test
    void testSetPropertyOnDetachedNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        TestInMemoryNodeModelTrackedNodes.prepareResolverForUpdateKeys(resolver);
        this.model.trackNode(selector, resolver);
        this.initDetachedNode(resolver);
        ImmutableNode rootNode = this.model.getRootNode();
        this.model.setProperty("fields.field(0).name", selector, (Object)NEW_FIELD, resolver);
        Assertions.assertSame((Object)rootNode, (Object)this.model.getRootNode());
        TestInMemoryNodeModelTrackedNodes.checkedForChangedField(this.fieldsNodeFromTrackedNode(), 0);
    }

    @Test
    void testSetPropertyOnTrackedNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        TestInMemoryNodeModelTrackedNodes.prepareResolverForUpdateKeys(resolver);
        this.model.trackNode(selector, resolver);
        this.model.setProperty("fields.field(0).name", selector, (Object)NEW_FIELD, resolver);
        TestInMemoryNodeModelTrackedNodes.checkedForChangedField(this.fieldsNodeFromModel(), 0);
        TestInMemoryNodeModelTrackedNodes.checkedForChangedField(this.fieldsNodeFromTrackedNode(), 0);
    }

    @Test
    void testTrackChildNodes() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        ImmutableNode node = NodeStructureHelper.nodeForKey(root, "tables");
        String[] keys = new String[node.getChildren().size()];
        for (int i = 0; i < keys.length; ++i) {
            ImmutableNode child = (ImmutableNode)node.getChildren().get(i);
            keys[i] = String.format("%s.%s(%d)", node.getNodeName(), child.getNodeName(), i);
            this.prepareNodeKey(resolver, child, keys[i]);
        }
        Mockito.when((Object)resolver.resolveNodeKey((Object)root, TEST_KEY, this.model.getNodeHandler())).thenReturn(Collections.singletonList(node));
        Collection selectors = this.model.trackChildNodes(TEST_KEY, resolver);
        Assertions.assertEquals((int)node.getChildren().size(), (int)selectors.size());
        int idx = 0;
        for (NodeSelector sel : selectors) {
            Assertions.assertEquals((Object)new NodeSelector(keys[idx]), (Object)sel);
            Assertions.assertEquals(node.getChildren().get(idx), (Object)this.model.getTrackedNode(sel), (String)("Wrong tracked node for " + sel));
            ++idx;
        }
    }

    @Test
    void testTrackChildNodesMultipleResults() {
        this.checkTrackChildNodesNoResult(Arrays.asList(NodeStructureHelper.nodeForKey(root, "tables/table(0)"), NodeStructureHelper.nodeForKey(root, "tables/table(1)")));
    }

    @Test
    void testTrackChildNodesNodeWithNoChildren() {
        this.checkTrackChildNodesNoResult(Collections.singletonList(NodeStructureHelper.nodeForKey(root, "tables/table(0)/name")));
    }

    @Test
    void testTrackChildNodesNoResults() {
        this.checkTrackChildNodesNoResult(Collections.emptyList());
    }

    @Test
    void testTrackChildNodeWithCreationExisting() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        String childName = "name";
        String parentKey = "tables/table(0)";
        String childKey = "tables/table(0)/name";
        ImmutableNode node = NodeStructureHelper.nodeForKey(this.model, "tables/table(0)");
        ImmutableNode child = NodeStructureHelper.nodeForKey(node, "name");
        Mockito.when((Object)resolver.resolveNodeKey((Object)root, TEST_KEY, this.model.getNodeHandler())).thenReturn(Collections.singletonList(node));
        this.prepareNodeKey(resolver, child, "tables/table(0)/name");
        NodeSelector childSelector = this.model.trackChildNodeWithCreation(TEST_KEY, "name", resolver);
        Assertions.assertEquals((Object)new NodeSelector("tables/table(0)/name"), (Object)childSelector);
        Assertions.assertSame((Object)child, (Object)this.model.getTrackedNode(childSelector));
    }

    @Test
    void testTrackChildNodeWithCreationMultipleResults() {
        List<ImmutableNode> nodes = Arrays.asList(NodeStructureHelper.nodeForKey(root, "tables/table(0)"), NodeStructureHelper.nodeForKey(root, "tables/table(1)"));
        this.checkTrackChildNodeWithCreationInvalidKey(nodes);
    }

    @Test
    void testTrackChildNodeWithCreationNonExisting() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        String childName = "space";
        String parentKey = "tables/table(0)";
        String childKey = "tables/table(0)/space";
        ImmutableNode node = NodeStructureHelper.nodeForKey(this.model, "tables/table(0)");
        Mockito.when((Object)resolver.resolveNodeKey((Object)root, TEST_KEY, this.model.getNodeHandler())).thenReturn(Collections.singletonList(node));
        Mockito.when((Object)resolver.nodeKey((Object)((ImmutableNode)ArgumentMatchers.any()), (Map)ArgumentMatchers.eq(new HashMap()), (NodeHandler)ArgumentMatchers.any())).thenReturn((Object)"tables/table(0)/space");
        NodeSelector childSelector = this.model.trackChildNodeWithCreation(TEST_KEY, "space", resolver);
        Assertions.assertEquals((Object)new NodeSelector("tables/table(0)/space"), (Object)childSelector);
        ImmutableNode child = this.model.getTrackedNode(childSelector);
        Assertions.assertEquals((Object)"space", (Object)child.getNodeName());
        Assertions.assertNull((Object)child.getValue());
        ImmutableNode parent = (ImmutableNode)this.model.getNodeHandler().getParent((Object)child);
        Assertions.assertEquals((Object)"table", (Object)parent.getNodeName());
        Assertions.assertEquals((Object)child, (Object)NodeStructureHelper.nodeForKey(this.model, "tables/table(0)/space"));
    }

    @Test
    void testTrackChildNodeWithCreationNoResults() {
        this.checkTrackChildNodeWithCreationInvalidKey(new ArrayList<ImmutableNode>());
    }

    @Test
    void testTrackedNodeClearedInOperation() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        this.model.clearTree(null, selector, resolver);
        Assertions.assertTrue((boolean)this.model.isTrackedNodeDetached(selector));
        ImmutableNode node = this.model.getTrackedNode(selector);
        Assertions.assertEquals((Object)"table", (Object)node.getNodeName());
        Assertions.assertFalse((boolean)this.model.getNodeHandler().isDefined((Object)node));
    }

    @Test
    void testTrackNodeKeyMultipleResults() {
        NodeSelector nodeSelector = new NodeSelector("tables.table.fields.field.name");
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        Assertions.assertThrows(ConfigurationRuntimeException.class, () -> this.model.trackNode(nodeSelector, resolver));
    }

    @Test
    void testTrackNodeKeyNoResults() {
        NodeSelector nodeSelector = new NodeSelector("tables.unknown");
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        Assertions.assertThrows(ConfigurationRuntimeException.class, () -> this.model.trackNode(nodeSelector, resolver));
    }

    @Test
    void testTrackNodeMultipleTimes() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModelTrackedNodes.createResolver();
        this.model.trackNode(selector, resolver);
        this.model.trackNode(selector, resolver);
        this.model.untrackNode(selector);
        Assertions.assertNotNull((Object)this.model.getTrackedNode(selector));
    }

    @Test
    void testUntrackNode() {
        this.model.trackNode(selector, TestInMemoryNodeModelTrackedNodes.createResolver());
        this.model.untrackNode(selector);
        Assertions.assertThrows(ConfigurationRuntimeException.class, () -> this.model.getTrackedNode(selector));
    }

    @Test
    void testUntrackNodeNonExisting() {
        Assertions.assertThrows(ConfigurationRuntimeException.class, () -> this.model.untrackNode(selector));
    }
}

